{{-- resources/views/peninjauan/partials/edit-tab-data-pemohon.blade.php --}}

<!-- Data Pemohon/Peralihan Tab -->
<div class="tab-pane fade" id="data-pemohon" role="tabpanel">
    <div class="card">
        <div class="card-header">
            Data Peralihan Tanah
        </div>
        <div class="card-body">
            <!-- Data Lokasi Section -->
            <h5 class="section-title">Data Lokasi</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="jalan_gg_blok">Jalan/Gg/Blok</label>
                        <input type="text" class="form-control" id="jalan_gg_blok" name="jalan_gg_blok"
                               value="{{ old('jalan_gg_blok', $peninjauan->jalan_gg_blok) }}"
                               placeholder="Nama jalan/gang/blok">
                        @error('jalan_gg_blok')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="rt">RT/RW</label>
                        <div class="d-flex align-items-center">
                            <input type="text" class="form-control" id="rt" name="rt"
                                   value="{{ old('rt', $peninjauan->rt) }}"
                                   placeholder="RT" style="width: 80px;">
                            <span class="mx-2">/</span>
                            <input type="text" class="form-control" id="rw" name="rw"
                                   value="{{ old('rw', $peninjauan->rw) }}"
                                   placeholder="RW" style="width: 80px;">
                        </div>
                        @error('rt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                        @error('rw')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kampung_kelurahan">Kampung/Kelurahan</label>
                        <input type="text" class="form-control" id="kampung_kelurahan" name="kampung_kelurahan"
                               value="{{ old('kampung_kelurahan', $peninjauan->kampung_kelurahan) }}"
                               placeholder="Nama kampung/kelurahan">
                        @error('kampung_kelurahan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kecamatan">Kecamatan</label>

                        <select class="form-control select2" id="kecamatan" name="kecamatan">
                            <option value="">-- Pilih Kecamatan --</option>
                            @foreach($kecamatans as $kecamatan)
                                <option value="{{ $kecamatan->id }}"
                                    {{ old('kecamatan', $peninjauan->kecamatan) == $kecamatan->id ? 'selected' : '' }}>
                                    {{ $kecamatan->nama_kecamatan }}
                                </option>
                            @endforeach
                        </select>
                        @error('kecamatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Batas-Batas Section -->
            <h5 class="section-title">Batas</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_utara">Utara</label>
                        <input type="text" class="form-control" id="batas_utara" name="batas_utara"
                               value="{{ old('batas_utara', $peninjauan->batas_utara) }}"
                               placeholder="Batas utara">
                        @error('batas_utara')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_timur">Timur</label>
                        <input type="text" class="form-control" id="batas_timur" name="batas_timur"
                               value="{{ old('batas_timur', $peninjauan->batas_timur) }}"
                               placeholder="Batas timur">
                        @error('batas_timur')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_selatan">Selatan</label>
                        <input type="text" class="form-control" id="batas_selatan" name="batas_selatan"
                               value="{{ old('batas_selatan', $peninjauan->batas_selatan) }}"
                               placeholder="Batas selatan">
                        @error('batas_selatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_barat">Barat</label>
                        <input type="text" class="form-control" id="batas_barat" name="batas_barat"
                               value="{{ old('batas_barat', $peninjauan->batas_barat) }}"
                               placeholder="Batas barat">
                        @error('batas_barat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            
            <hr>
            <!-- Hak Penguasaan Section -->
            {{-- <h5 class="section-title">Hak Yasan Patak D/C (Nomor, Persil, Klas)</h5> --}}
            <div class="row mb-3">
                 <div class="col-6">
                    <div class="form-group">
                        <label for="luas">Luas</label>
                        <div class="d-flex align-items-center">
                            <input type="number" class="form-control" id="luas" name="luas"
                                   value="{{ old('luas', $peninjauan->luas) }}"
                                   placeholder="Luas tanah" style="width: 200px;" step="0.01">
                            <span class="ml-2">m²</span>
                        </div>
                        @error('luas')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="tanah_negara">Tanah Negara (Jenis dan Nomor Serp)</label>
                        <input type="text" class="form-control" id="tanah_negara" name="tanah_negara"
                               value="{{ old('tanah_negara', $peninjauan->tanah_negara) }}"
                               placeholder="Jenis dan nomor serp">
                        @error('tanah_negara')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                
            </div>

            <div class="row mb-3">
                <div class="col-6">
                    <div class="form-group">
                        <label for="hak_yasan_patok">Hak Yasan Patok D/C (nomor, Persil, klas)</label>
                        <input type="text" class="form-control" id="hak_yasan_patok" name="hak_yasan_patok"
                               value="{{ old('hak_yasan_patok', $peninjauan->hak_yasan_patok) }}"
                               placeholder="">
                        @error('hak_yasan_patok')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="sppt">SPPT (Tahun dan Nomor)</label>
                        <input type="text" class="form-control" id="sppt" name="sppt"
                               value="{{ old('sppt', $peninjauan->sppt) }}"
                               placeholder="Tahun dan nomor SPPT">
                        @error('sppt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Data Pemilik Section -->
            <h5 class="section-title">Data Pemilik</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="nama_pemilik">Nama</label>
                        <input type="text" class="form-control" id="nama_pemilik" name="nama_pemilik"
                               value="{{ old('nama_pemilik', $peninjauan->nama_pemilik) }}"
                               placeholder="Nama pemilik">
                        @error('nama_pemilik')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="dikuasai_sejak">Dikuasai Sejak Tahun</label>
                        <input type="number" class="form-control" id="dikuasai_sejak" name="dikuasai_sejak"
                               value="{{ old('dikuasai_sejak', $peninjauan->dikuasai_sejak) }}"
                               placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                        @error('dikuasai_sejak')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="dikuasai_oleh">Dikuasai Oleh</label>
                        <input type="text" class="form-control" id="dikuasai_oleh" name="dikuasai_oleh"
                               value="{{ old('dikuasai_oleh', $peninjauan->dikuasai_oleh) }}"
                               placeholder="Nama yang menguasai">
                        @error('dikuasai_oleh')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Peralihan Tanah Section -->
            <h5 class="section-title">Peralihan Tanah Secara Berturut-turut</h5>
            @php
                // Get existing pemilik data or create empty array
                $pemilikData = $peninjauan->peralihan ?? collect();
                // Ensure we have at least 4 slots
                for($i = $pemilikData->count(); $i < 4; $i++) {
                    $pemilikData->push((object)[
                        'urutan' => $i + 1,
                        'pada_tahun' => '',
                        'dikuasai_oleh' => '',
                        'dialihkan' => '',
                        'luas' => ''
                    ]);
                }
            @endphp
            @foreach($pemilikData->take(4) as $index => $pemilik)
        @php $i = $index + 1; @endphp
        <div class="card bg-light mb-3">
            <div class="card-body">
                <h6 class="card-title">Pemilik {{ $i }}</h6>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pemilik{{ $i }}_tahun">Pada Tahun</label>
                            <input type="number" class="form-control" id="pemilik{{ $i }}_tahun" name="pemilik[{{ $i }}][pada_tahun]"
                                value="{{ old('pemilik.'.$i.'.pada_tahun', $pemilik->pada_tahun ?? '') }}"
                                placeholder="Tahun" min="1900" max="{{ date('Y') }}">
                            @error('pemilik.'.$i.'.pada_tahun')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pemilik{{ $i }}_dikuasai">Dikuasai oleh</label>
                            <input type="text" class="form-control" id="pemilik{{ $i }}_dikuasai" name="pemilik[{{ $i }}][dikuasai_oleh]"
                                value="{{ old('pemilik.'.$i.'.dikuasai_oleh', $pemilik->dikuasai_oleh ?? '') }}"
                                placeholder="Nama yang menguasai">
                            @error('pemilik.'.$i.'.dikuasai_oleh')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pemilik{{ $i }}_dialihkan">Dialihkan</label>
                            <select class="form-control" id="pemilik{{ $i }}_dialihkan" name="pemilik[{{ $i }}][dialihkan]">
                                <option value="">-- Pilih --</option>
                                <option value="sebagian" {{ old('pemilik.'.$i.'.dialihkan', $pemilik->dialihkan ?? '') == 'sebagian' ? 'selected' : '' }}>Sebagian</option>
                                <option value="seluruhnya" {{ old('pemilik.'.$i.'.dialihkan', $pemilik->dialihkan ?? '') == 'seluruhnya' ? 'selected' : '' }}>Seluruhnya</option>

                            </select>
                            @error('pemilik.'.$i.'.dialihkan')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pemilik{{ $i }}_luas">Luas (m²)</label>
                            <input type="number" class="form-control" id="pemilik{{ $i }}_luas" name="pemilik[{{ $i }}][luas]"
                                value="{{ old('pemilik.'.$i.'.luas', $pemilik->luas ?? '') }}"
                                placeholder="Luas" step="0.01">
                            @error('pemilik.'.$i.'.luas')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            {{-- <button type="button" class="btn btn-secondary" onclick="previousTab()">
                ← Sebelumnya
            </button>
            <div>
                <button type="button" class="btn btn-secondary mr-2" onclick="saveDraft()">
                    💾 Simpan Draft
                </button>
                <button type="button" class="btn btn-primary" onclick="nextTab()">
                    Selanjutnya →
                </button>
            </div> --}}
        </div>
    </div>
</div>
